/* $Id: xwindows.c,v 1.4 1998/04/05 10:33:48 tonyg Exp $ */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "memory.h"
#include "class.h"
#include "prim.h"
#include "pair.h"
#include "symbol.h"
#include "string.h"
#include "buffer.h"
#include "scan.h"
#include "parse.h"
#include "stream.h"
#include "xwindows.h"
#include "vector.h"
#include "thread.h"

#if WANT_XWINDOWS

#include <X11/Xlib.h>
#include <X11/Xutil.h>

OBJECT x_ptr_class;
OBJECT x_peer_class;

#define GET_XPTR(x)		(*(void **) BIDX(x, 0))
#define SET_XPTR(x, v)		(*(void **) BIDX(x, 0) = (v))

#define GET_DISPLAY(x)		((Display *) GET_XPTR(x))
#define GET_FONTSTRUCT(x)	((XFontStruct *) GET_XPTR(x))

#define GET_WINDOW(x)		((Window) NUM(x))
#define GET_ATOM(x)		((Atom) NUM(x))
#define GET_GC(x)		((GC) NUM(x))

PRIVATE int moofXErrorHandler(Display *d, XErrorEvent *e) {
  char buf[1024];

  XGetErrorText(d, e->error_code, buf, 1000);
  raise_exception("x-windows-exception", newstring(buf));

  return 0;
}

void init_xwindows(void) {
  XSetErrorHandler(moofXErrorHandler);

  x_ptr_class = newclass(object_class, X_PTR_SIZE, NULL);
  SET(newsym("<x-pointer>"), SYM_VALUE, x_ptr_class);

  x_peer_class = newclass(object_class, X_PEER_SIZE, NULL);
  SET(newsym("<x-peer>"), SYM_VALUE, x_peer_class);
}

PRIVATE OBJECT makepointer(void *p) {
  if (p) {
    OBJECT ptr = NewObject(x_ptr_class, 0, X_PTR_BINARY_SIZE);

    SET_XPTR(ptr, p);
    return ptr;
  } else
    return NULL;
}

#define makeid(x)	MKNUM((unsigned long) x)

/* Methods */

PRIVATE OBJECT peer_initialize(OBJECT self) {
  return self;
}

PRIVATE OBJECT peer_display_open(OBJECT self, OBJECT display_name) {
  if (display_name == NULL)
    return makepointer(XOpenDisplay(NULL));
  else
    return makepointer(XOpenDisplay(BIDX(display_name, 0)));
}

PRIVATE OBJECT peer_display_close(OBJECT self, OBJECT display) {
  if (display != NULL)
    XCloseDisplay(GET_DISPLAY(display));

  return NULL;
}

PRIVATE OBJECT peer_display_rootwin(OBJECT self, OBJECT display) {
  return makeid(DefaultRootWindow(GET_DISPLAY(display)));
}

#define BINDPAIR(n,v)	R[0] = newsym(n);\
			R[1] = v;\
			R[0] = cons(R[0],R[1]);\
			ev = cons(R[0],ev)

PRIVATE OBJECT peer_display_nextevent(OBJECT self, OBJECT display) {
  XEvent e;
  OBJECT ev = NULL;
  OBJECT R[2];

  temp_register(&ev, 1);
  R[0] = R[1] = NULL;
  temp_register(R, 2);

  XNextEvent(GET_DISPLAY(display), &e);

  switch (e.type) {
    case KeyPress:
    case KeyRelease:
      BINDPAIR("type", newsym(e.type == KeyPress ? "key-press" : "key-release"));
      BINDPAIR("time", MKNUM(e.xkey.time));
      BINDPAIR("x", MKNUM(e.xkey.x));
      BINDPAIR("y", MKNUM(e.xkey.y));
      BINDPAIR("x-root", MKNUM(e.xkey.x_root));
      BINDPAIR("y-root", MKNUM(e.xkey.x_root));
      BINDPAIR("state", MKNUM(e.xkey.state));
      BINDPAIR("keycode", MKNUM(e.xkey.keycode));
      BINDPAIR("samescreen?", e.xkey.same_screen ? true : false);

      {
	char text[16];
	KeySym key;

	memset(text, 0, 16);
	XLookupString(&e.xkey, text, 16, &key, NULL);
	BINDPAIR("string", newstring(text));
	BINDPAIR("keysym", makeid(key));
      }

      break;

    case ButtonPress:
    case ButtonRelease:
      BINDPAIR("type", newsym(e.type == ButtonPress ? "button-press" : "button-release"));
      BINDPAIR("time", MKNUM(e.xbutton.time));
      BINDPAIR("x", MKNUM(e.xbutton.x));
      BINDPAIR("y", MKNUM(e.xbutton.y));
      BINDPAIR("x-root", MKNUM(e.xbutton.x_root));
      BINDPAIR("y-root", MKNUM(e.xbutton.x_root));
      BINDPAIR("state", MKNUM(e.xbutton.state));
      BINDPAIR("button", MKNUM(e.xbutton.button));
      BINDPAIR("samescreen?", e.xbutton.same_screen ? true : false);
      break;

    case MotionNotify:
      BINDPAIR("type", newsym("pointer-motion"));
      BINDPAIR("time", MKNUM(e.xmotion.time));
      BINDPAIR("x", MKNUM(e.xmotion.x));
      BINDPAIR("y", MKNUM(e.xmotion.y));
      BINDPAIR("x-root", MKNUM(e.xmotion.x_root));
      BINDPAIR("y-root", MKNUM(e.xmotion.x_root));
      BINDPAIR("state", MKNUM(e.xmotion.state));
      BINDPAIR("hint?", MKNUM(e.xmotion.is_hint));
      BINDPAIR("samescreen?", e.xmotion.same_screen ? true : false);
      break;

    case VisibilityNotify:
      BINDPAIR("type", newsym("visibility-notify"));
      BINDPAIR("state", MKNUM(e.xvisibility.state));
      break;

    case Expose:
      BINDPAIR("type", newsym("expose"));
      BINDPAIR("x", MKNUM(e.xexpose.x));
      BINDPAIR("y", MKNUM(e.xexpose.y));
      BINDPAIR("width", MKNUM(e.xexpose.width));
      BINDPAIR("height", MKNUM(e.xexpose.height));
      BINDPAIR("count", MKNUM(e.xexpose.count));
      break;

    case DestroyNotify:
      BINDPAIR("type", newsym("destroy-notify"));
      break;

    case ClientMessage:
      if (e.xclient.data.l[0] == XInternAtom(GET_DISPLAY(display), "WM_DELETE_WINDOW", 0)) {
	BINDPAIR("type", newsym("window-delete"));
      } else {
	BINDPAIR("type", newsym("client-message"));
	BINDPAIR("format", MKNUM(e.xclient.format));
	BINDPAIR("data", MKNUM(e.xclient.data.l[0]));
      }
      break;

    case MappingNotify:
      XRefreshKeyboardMapping(&e.xmapping);
      break;

    default:
      BINDPAIR("type", MKNUM(e.type));
      break;
  }

  BINDPAIR("window", makeid(e.xany.window));
  BINDPAIR("sendevent?", e.xany.send_event ? true : false);
  BINDPAIR("serial-number", MKNUM(e.xany.serial));

  deregister_root(2);
  return ev;
}

PRIVATE OBJECT peer_get_gc(OBJECT self, OBJECT display, OBJECT win) {
  return makeid(XCreateGC(GET_DISPLAY(display), GET_WINDOW(win), 0, NULL));
}

PRIVATE OBJECT peer_free_gc(OBJECT self, OBJECT display, OBJECT gc) {
  XFreeGC(GET_DISPLAY(display), GET_GC(gc));
  return NULL;
}

PRIVATE OBJECT peer_get_font(OBJECT self, OBJECT display,
			     OBJECT name, OBJECT weight, OBJECT face, OBJECT size) {
  char buf[256];
  XFontStruct *fs;

  sprintf(buf, "-*-%s-%s-%s-*--%ld-*-*-*-*-*-*",
	  BIDX(name, 0),
	  BIDX(weight, 0),
	  BIDX(face, 0),
	  NUM(size));

  fs = XLoadQueryFont(GET_DISPLAY(display), buf);

  if (fs == NULL)
    return NULL;

  return makepointer(fs);
}

PRIVATE OBJECT peer_free_font(OBJECT self, OBJECT display, OBJECT font) {
  XFreeFont(GET_DISPLAY(display), GET_FONTSTRUCT(font));
  return NULL;
}

PRIVATE OBJECT peer_make_window(OBJECT self, OBJECT display, OBJECT parent,
				OBJECT title,
				OBJECT x, OBJECT y, OBJECT width, OBJECT height) {
  Display *d = GET_DISPLAY(display);
  Window w = XCreateWindow(d, GET_WINDOW(parent),
			   NUM(x), NUM(y), NUM(width), NUM(height),
			   0, CopyFromParent, CopyFromParent, CopyFromParent,
			   0, NULL);

  XSelectInput(d, w,
	       KeyPressMask | KeyReleaseMask |
	       ButtonPressMask | ButtonReleaseMask |
	       EnterWindowMask |
	       LeaveWindowMask |
	       PointerMotionMask |
	       KeymapStateMask |
	       ExposureMask |
	       VisibilityChangeMask |
	       StructureNotifyMask |
	       FocusChangeMask |
	       0);

  XStoreName(d, w, BIDX(title, 0));
  XSetIconName(d, w, BIDX(title, 0));

  {
    Atom WDW = XInternAtom(d, "WM_DELETE_WINDOW", 0);
    XSetWMProtocols(d, w, &WDW, 1);
  }

  return makeid(w);
}

PRIVATE OBJECT peer_free_window(OBJECT self, OBJECT d, OBJECT w) {
  XDestroyWindow(GET_DISPLAY(d), GET_WINDOW(w));
  return NULL;
}

PRIVATE OBJECT peer_window_show(OBJECT self, OBJECT disp, OBJECT win) {
  XMapWindow(GET_DISPLAY(disp), GET_WINDOW(win));
  return self;
}

PRIVATE OBJECT peer_window_hide(OBJECT self, OBJECT disp, OBJECT win) {
  XUnmapWindow(GET_DISPLAY(disp), GET_WINDOW(win));
  return self;
}

PRIVATE OBJECT peer_alloc_color(OBJECT self, OBJECT display, OBJECT r, OBJECT g, OBJECT b) {
  Display *d = GET_DISPLAY(display);
  int result;
  XColor color;

  color.red = NUM(r);
  color.green = NUM(g);
  color.blue = NUM(b);

  result = XAllocColor(d, DefaultColormap(d, DefaultScreen(d)), &color);

  if (result)
    return MKNUM(color.pixel);
  else
    return false;
}

PRIVATE OBJECT peer_set_bg(OBJECT self, OBJECT display, OBJECT gc, OBJECT color) {
  XSetBackground(GET_DISPLAY(display), GET_GC(gc), NUM(color));
  return NULL;
}

PRIVATE OBJECT peer_set_fg(OBJECT self, OBJECT display, OBJECT gc, OBJECT color) {
  XSetForeground(GET_DISPLAY(display), GET_GC(gc), NUM(color));
  return NULL;
}

PRIVATE OBJECT peer_set_font(OBJECT self, OBJECT display, OBJECT gc, OBJECT font) {
  XSetFont(GET_DISPLAY(display), GET_GC(gc), GET_FONTSTRUCT(font)->fid);
  return NULL;
}

PRIVATE OBJECT peer_set_clip(OBJECT self, OBJECT display, OBJECT gc,
			     OBJECT x, OBJECT y, OBJECT rect) {
  XRectangle r;

  r.x = NUM(IGET(rect, 0));
  r.y = NUM(IGET(rect, 1));
  r.width = NUM(IGET(rect, 2)) + 1;	/* fudge factor :-( */
  r.height = NUM(IGET(rect, 3)) + 1;

  XSetClipRectangles(GET_DISPLAY(display), GET_GC(gc), NUM(x), NUM(y), &r, 1, Unsorted);
  return NULL;
}

PRIVATE OBJECT peer_text_width(OBJECT self, OBJECT font, OBJECT str) {
  return MKNUM(XTextWidth(GET_FONTSTRUCT(font), BIDX(str, 0), strlen(BIDX(str, 0))));
}

#define BINDRESULT(n,v)		R[0] = newsym(n);\
				R[1] = v;\
				R[0] = cons(R[0],R[1]);\
				result = cons(R[0], result)

PRIVATE OBJECT peer_get_geom(OBJECT self, OBJECT display, OBJECT window) {
  Window parent;
  int x, y;
  unsigned int w, h;
  unsigned int b, d;
  OBJECT result = NULL;
  OBJECT R[2];

  XGetGeometry(GET_DISPLAY(display), GET_WINDOW(window),
	       &parent, &x, &y, &w, &h, &b, &d);

  temp_register(&result, 1);
  R[0] = R[1] = NULL;
  temp_register(R, 2);

  BINDRESULT("depth", MKNUM(d));
  BINDRESULT("border", MKNUM(b));
  BINDRESULT("height", MKNUM(h));
  BINDRESULT("width", MKNUM(w));
  BINDRESULT("y", MKNUM(y));
  BINDRESULT("x", MKNUM(x));
  BINDRESULT("parent", makeid(parent));

  deregister_root(2);
  return result;
}

PRIVATE OBJECT peerDrawRectangle(OBJECT self, OBJECT display, OBJECT window, OBJECT gc,
				 OBJECT x, OBJECT y, OBJECT w, OBJECT h) {
  XDrawRectangle(GET_DISPLAY(display), GET_WINDOW(window), GET_GC(gc),
		 NUM(x), NUM(y), NUM(w), NUM(h));
  return NULL;
}

PRIVATE OBJECT peerDrawLine(OBJECT self, OBJECT display, OBJECT window, OBJECT gc,
			    OBJECT x, OBJECT y, OBJECT x1, OBJECT y1) {
  XDrawLine(GET_DISPLAY(display), GET_WINDOW(window), GET_GC(gc),
	    NUM(x), NUM(y), NUM(x1), NUM(y1));
  return NULL;
}

PRIVATE OBJECT peerFillRectangle(OBJECT self, OBJECT display, OBJECT window, OBJECT gc,
				 OBJECT x, OBJECT y, OBJECT w, OBJECT h) {
  XFillRectangle(GET_DISPLAY(display), GET_WINDOW(window), GET_GC(gc),
		 NUM(x), NUM(y), NUM(w), NUM(h));
  return NULL;
}

PRIVATE OBJECT peerFillArc(OBJECT self, OBJECT display, OBJECT window, OBJECT gc,
			   OBJECT x, OBJECT y, OBJECT w, OBJECT h, OBJECT a1, OBJECT a2) {
  XFillArc(GET_DISPLAY(display), GET_WINDOW(window), GET_GC(gc),
	   NUM(x), NUM(y), NUM(w), NUM(h), NUM(a1), NUM(a2));
  return NULL;
}

PRIVATE OBJECT peerDrawArc(OBJECT self, OBJECT display, OBJECT window, OBJECT gc,
			   OBJECT x, OBJECT y, OBJECT w, OBJECT h, OBJECT a1, OBJECT a2) {
  XDrawArc(GET_DISPLAY(display), GET_WINDOW(window), GET_GC(gc),
	   NUM(x), NUM(y), NUM(w), NUM(h), NUM(a1), NUM(a2));
  return NULL;
}

PRIVATE OBJECT peerDrawString(OBJECT self, OBJECT display, OBJECT window, OBJECT gc,
			      OBJECT x, OBJECT y, OBJECT str) {
  XDrawString(GET_DISPLAY(display), GET_WINDOW(window), GET_GC(gc),
	      NUM(x), NUM(y), BIDX(str, 0), strlen(BIDX(str, 0)));
  return NULL;
}

#define AMPTR(n,f,a)	addmeth(n,f,a,clptr)
#define AMPEER(n,f,a)	addmeth(n,f,a,clpeer)

void init_meth_xwindows(void) {
  OBJECT clptr = NULL;
  OBJECT clpeer = NULL;

  temp_register(&clptr, 1);
  temp_register(&clpeer, 1);
  clptr = cons(x_ptr_class, NULL);
  clpeer = cons(x_peer_class, NULL);

  AMPEER("initialize", peer_initialize, 1);

  AMPEER("open-display", peer_display_open, 2);
  AMPEER("close-display", peer_display_close, 2);
  AMPEER("root-window", peer_display_rootwin, 2);
  AMPEER("next-event", peer_display_nextevent, 2);
  AMPEER("obtain-graphics-context", peer_get_gc, 3);
  AMPEER("release-graphics-context", peer_free_gc, 3);
  AMPEER("obtain-font-handle", peer_get_font, 6);
  AMPEER("release-font-handle", peer_free_font, 3);

  AMPEER("make-window", peer_make_window, 8);
  AMPEER("free-window", peer_free_window, 3);
  AMPEER("show-window", peer_window_show, 3);
  AMPEER("hide-window", peer_window_hide, 3);

  AMPEER("allocate-color", peer_alloc_color, 5);
  AMPEER("set-bg-color", peer_set_bg, 4);
  AMPEER("set-fg-color", peer_set_fg, 4);
  AMPEER("set-font", peer_set_font, 4);
  AMPEER("set-clip-rectangle", peer_set_clip, 6);

  AMPEER("text-width", peer_text_width, 3);

  AMPEER("get-window-geometry", peer_get_geom, 3);
  AMPEER("draw-rectangle", peerDrawRectangle, 8);
  AMPEER("draw-line", peerDrawLine, 8);
  AMPEER("fill-rectangle", peerFillRectangle, 8);
  AMPEER("fill-arc", peerFillArc, 10);
  AMPEER("draw-arc", peerDrawArc, 10);
  AMPEER("draw-string", peerDrawString, 7);

  {
    clptr = newsym("x-windows");
    clpeer = newsym("*features*");

    clptr = cons(clptr, GET(clpeer, SYM_VALUE));
    SET(clpeer, SYM_VALUE, clptr);
  }

  deregister_root(2);
}

#else /* don't WANT_XWINDOWS */

void init_xwindows(void) {
}

void init_meth_xwindows(void) {
}

#endif /* WANT_XWINDOWS */
