Procedure KillIfNoSym(T: TEntry);
Var
   P: PSymbol;
   F: Boolean;
Begin
     P := SymTab;
     F := False;
     While P<>Nil do
     Begin
          If P^.Entry.Class=T_PROC then
             If P^.Entry.PData=T.PData then F := True;
          P := P^.Next;
     End;
     If Not(F) then
        If T.Class=T_PROC then KillProc(T.PData);
End;

Procedure AddFun;
Var
   A1,A2,R: TEntry;
Begin
     Pop(A2);
     Pop(A1);
     If Not(A1.Class in [T_INT,T_FLOAT]) or
        Not(A2.Class in [T_INT,T_FLOAT]) then Error('ADD: Bad argument.');
     If A1.Class=A2.Class then
     Begin
          R.Class := A1.Class;
          Case R.Class of
               T_INT: R.IData := A1.IData+A2.IData;
               T_FLOAT: R.FData := A1.FData+A2.FData;
          End;
     End else
     Begin
          R.Class := T_FLOAT;
          If A1.Class=T_INT then R.FData := A1.IData else
                                 R.FData := A1.FData;
          If A2.Class=T_INT then R.FData := R.FData+A2.IData else
                                 R.FData := R.FData+A2.FData;
     End;
     Push(R);
End;

Procedure SubFun;
Var
   A1,A2,R: TEntry;
Begin
     Pop(A2);
     Pop(A1);
     If Not(A1.Class in [T_INT,T_FLOAT]) or
        Not(A2.Class in [T_INT,T_FLOAT]) then Error('SUB: Bad argument.');
     If A1.Class=A2.Class then
     Begin
          R.Class := A1.Class;
          Case R.Class of
               T_INT: R.IData := A1.IData-A2.IData;
               T_FLOAT: R.FData := A1.FData-A2.FData;
          End;
     End else
     Begin
          R.Class := T_FLOAT;
          If A1.Class=T_INT then R.FData := A1.IData else
                                 R.FData := A1.FData;
          If A2.Class=T_INT then R.FData := R.FData-A2.IData else
                                 R.FData := R.FData-A2.FData;
     End;
     Push(R);
End;

Procedure MulFun;
Var
   A1,A2,R: TEntry;
Begin
     Pop(A2);
     Pop(A1);
     If Not(A1.Class in [T_INT,T_FLOAT]) or
        Not(A2.Class in [T_INT,T_FLOAT]) then Error('MUL: Bad argument.');
     If A1.Class=A2.Class then
     Begin
          R.Class := A1.Class;
          Case R.Class of
               T_INT: R.IData := A1.IData*A2.IData;
               T_FLOAT: R.FData := A1.FData*A2.FData;
          End;
     End else
     Begin
          R.Class := T_FLOAT;
          If A1.Class=T_INT then R.FData := A1.IData else
                                 R.FData := A1.FData;
          If A2.Class=T_INT then R.FData := R.FData*A2.IData else
                                 R.FData := R.FData*A2.FData;
     End;
     Push(R);
End;

Procedure DivFun;
Var
   A1,A2,R: TEntry;
Begin
     Pop(A2);
     Pop(A1);
     If Not(A1.Class in [T_INT,T_FLOAT]) or
        Not(A2.Class in [T_INT,T_FLOAT]) then Error('DIV: Bad argument.');
     If A1.Class=A2.Class then
     Begin
          R.Class := A1.Class;
          Case R.Class of
               T_INT: R.IData := A1.IData div A2.IData;
               T_FLOAT: R.FData := A1.FData/A2.FData;
          End;
     End else
     Begin
          R.Class := T_FLOAT;
          If A1.Class=T_INT then R.FData := A1.IData else
                                 R.FData := A1.FData;
          If A2.Class=T_INT then R.FData := R.FData/A2.IData else
                                 R.FData := R.FData/A2.FData;
     End;
     Push(R);
End;

Procedure DispFun;
Var
   T: TEntry;
Begin
     Pop(T);
     Case T.Class of
          T_INT: Write(T.IData);
          T_STRING: Write(T.SData);
          T_SYM: Write(T.SData);
          T_FLOAT: Write(T.FData);
          T_PROC: Begin Write('PROCEDURE'); KillIfNoSym(T); End;
     End;
End;

Procedure RoundFun;
Var
   T: TEntry;
   L: Longint;
Begin
     Pop(T);
     If T.Class in [T_INT,T_FLOAT] then
     Begin
          L := T.IData;
          If T.Class = T_FLOAT then L := Round(T.FData);
          T.Class := T_INT;
          T.IData := L;
          Push(T);
          Exit;
     End;
     Error('ROUND: Non-numeric argument');
End;

Procedure DefineFun;
Var
   S,V: TEntry;
Begin
     Pop(S);
     Pop(V);
     If S.Class<>T_SYM then Error('DEFINE: Argument 1 is not a quoted symbol');
     AddSymbol(S.SData,V);
End;

Procedure StrCatFun;
Var
   A1,A2,R: TEntry;
Begin
     Pop(A2);
     Pop(A1);
     If (A1.Class<>T_STRING) or (A2.Class<>T_STRING) then Error('STR+: Arguments must be strings');
     R.Class := T_STRING;
     R.SData := A1.SData+A2.SData;
     Push(R);
End;

Procedure ToNumFun;
Var
   A,R: TEntry;
   C: Word;
Begin
     Pop(A);
     If Not(A.Class in [T_STRING,T_SYM]) then Error('->NUM: Argument must be STRING or SYMBOL');
     R.Class := T_FLOAT;
     Val(A.SData,R.FData,C);
     Push(R);
End;

Procedure ToStrFun;
Var
   A,R: TEntry;
Begin
     Pop(A);
     If Not(A.Class in [T_INT,T_FLOAT]) then Error('->STR: Argument must be INT or FLOAT');
     R.Class := T_STRING;
     If A.Class=T_INT then Str(A.IData,R.SData) else
                           Str(A.FData,R.SData);
     Push(R);
End;

Function FoundDupData(P: PSymbol): Boolean;
Var
   F: Boolean;
   PP: PSymbol;
Begin
     PP := SymTab;
     F := False;
     While PP<>Nil do
     Begin
          If (PP<>P) and (PP^.Entry.Class=P^.Entry.Class)
                     and (PP^.Entry.IData=P^.Entry.IData) then F := True;
          PP := PP^.Next;
     End;
     FoundDupData := F;
End;

Procedure SetFun;
Var
   V,S: TEntry;
   P: PSymbol;
Begin
     Pop(S);
     Pop(V);
     If S.Class<>T_SYM then Error('SET: Argument 1 must be quoted symbol');
     P := SymTab;
     While P<>Nil do
     Begin
          If P^.Symbol=S.SData then
          Begin
               If Not(FoundDupData(P)) and (P^.Entry.Class=T_PROC) then
                  KillProc(P^.Entry.PData);
               P^.Entry := V;
               Exit;
          End;
          P := P^.Next;
     End;
     Error('SET: Undefined symbol!');
End;

Procedure EvalFun;
Var
   T: TEntry;
Begin
     Pop(T);
     If T.Class<>T_PROC then Error('EVAL: Argument must be a procedure');
     RunProc(T);
End;

Procedure ReadFun;
Var
   R: TEntry;
   S: String;
Begin
     R.Class := T_STRING;
     Readln(S);
     R.SData := S;
     Push(R);
End;

Procedure GetKeyFun;
Var
   R: TEntry;
   C: Char;
Begin
     R.Class := T_STRING;
     C := ReadKey;
     R.SData := C;
     Push(R);
End;

Procedure KeyPressedFun;
Var
   R: TEntry;
Begin
     R.Class := T_INT;
     R.IData := Longint(KeyPressed);
     Push(R);
End;

Procedure IfFun;
Var
   Test,TP: TEntry;
Begin
     Pop(TP);
     Pop(Test);
     If Test.Class<>T_INT then Error('IF: Test must return an INT');
     If TP.Class<>T_PROC then Error('IF: Argument 2 must be a procedure');
     If Test.IData<>0 then RunProc(TP);
     KillIfNoSym(TP);
End;

Procedure IfElseFun;
Var
   Test,TP,FP: TEntry;
Begin
     Pop(FP);
     Pop(TP);
     Pop(Test);
     If Test.Class<>T_INT then Error('IFELSE: Test must return an INT');
     If TP.Class<>T_PROC then Error('IFELSE: Argument 2 must be a procedure');
     If FP.Class<>T_PROC then Error('IFELSE: Argument 3 must be a procedure');
     If Test.IData=0 then RunProc(FP) else
                          RunProc(TP);
     KillIfNoSym(TP);
     KillIfNoSym(FP);
End;

Procedure EqFun;
Var
   A1,A2,R: TEntry;
Begin
     Pop(A2);
     Pop(A1);
     R.Class := T_INT;
     If A1.Class<>A2.Class then
     Begin
          R.IData := 0;
          Push(R);
          Exit;
     End;
     Case A1.Class of
          T_INT: R.IData := Longint(A1.IData=A2.IData);
          T_FLOAT: R.IData := Longint(Abs(A1.FData-A2.FData)<FloatEq);
          T_STRING, T_SYM: R.IData := Longint(A1.SData=A2.SData);
          T_PROC: Begin R.IData := 0; KillIfNoSym(A1); KillIfNoSym(A2); End;
     End;
     Push(R);
End;

Procedure UpStrFun;
Var
   A,R: TEntry;
   I: Integer;
Begin
     Pop(A);
     If A.Class<>T_STRING then Error('UPSTR: Argument must be a string');
     R.Class := T_STRING;
     R.SData := A.SData;
     For I := 1 to Length(R.SData) do R.SData[I] := UpCase(R.SData[I]);
     Push(R);
End;

Procedure DropFun;
Var
   T: TEntry;
Begin
     Pop(T);
End;

Procedure HaltFun;
Var
   T: TEntry;
Begin
     Pop(T);
     If T.Class=T_INT then Halt(T.IData) else
                           Halt(0);
End;

Procedure ToChrFun;
Var
   A,R: TEntry;
Begin
     Pop(A);
     If A.Class<>T_INT then Error('->CHR: Expects an INT as argument');
     R.Class := T_STRING;
     R.SData := Char(A.IData);
     Push(R);
End;

Procedure ChrToIntFun;
Var
   A,R: TEntry;
Begin
     Pop(A);
     If A.Class<>T_STRING then Error('CHR->INT: Expects STRING as first arg');
     R.Class := T_INT;
     If Length(A.SData)>0 then R.IData := Byte(A.SData[1]) else
                               R.IData := 0;
     Push(R);
End;

Procedure SubStrFun;
Var
   S,I,L,R: TEntry;
Begin
     Pop(L);
     Pop(I);
     Pop(S);
     If S.Class<>T_STRING then Error('SUBSTR: Expects STRING as first arg');
     If I.Class<>T_INT then Error('SUBSTR: Expects INT as second arg (index)');
     If L.Class<>T_INT then Error('SUBSTR: Expects INT as third arg (length)');
     R.Class := T_STRING;
     R.SData := Copy(S.SData,I.IData,L.IData);
     Push(R);
End;

Procedure StrLenFun;
Var
   S,R: TEntry;
Begin
     Pop(S);
     If S.Class<>T_STRING then Error('STRLEN: Expects STRING as argument');
     R.Class := T_INT;
     R.IData := Length(S.SData);
     Push(R);
End;

Procedure SwapFun;
Var
   A1,A2: TEntry;
Begin
     Pop(A2);
     Pop(A1);
     Push(A2);
     Push(A1);
End;

Procedure LFun;
Var
   A1,A2,R: TEntry;
Begin
     Pop(A2);
     Pop(A1);
     R.Class := T_INT;
     If A1.Class<>A2.Class then
     Begin
          R.IData := 0;
          Push(R);
          Exit;
     End;
     Case A1.Class of
          T_INT: R.IData := Longint(A1.IData<A2.IData);
          T_FLOAT: R.IData := Longint(A1.FData<A2.FData);
          T_STRING, T_SYM: R.IData := Longint(A1.SData<A2.SData);
          T_PROC: Begin R.IData := 0; KillIfNoSym(A1); KillIfNoSym(A2); End;
     End;
     Push(R);
End;

Procedure GFun;
Var
   A1,A2,R: TEntry;
Begin
     Pop(A2);
     Pop(A1);
     R.Class := T_INT;
     If A1.Class<>A2.Class then
     Begin
          R.IData := 0;
          Push(R);
          Exit;
     End;
     Case A1.Class of
          T_INT: R.IData := Longint(A1.IData>A2.IData);
          T_FLOAT: R.IData := Longint(A1.FData>A2.FData);
          T_STRING, T_SYM: R.IData := Longint(A1.SData>A2.SData);
          T_PROC: Begin R.IData := 0; KillIfNoSym(A1); KillIfNoSym(A2); End;
     End;
     Push(R);
End;

Procedure LEFun;
Var
   A1,A2,R: TEntry;
Begin
     Pop(A2);
     Pop(A1);
     R.Class := T_INT;
     If A1.Class<>A2.Class then
     Begin
          R.IData := 0;
          Push(R);
          Exit;
     End;
     Case A1.Class of
          T_INT: R.IData := Longint(A1.IData<=A2.IData);
          T_FLOAT: R.IData := Longint((Abs(A1.FData-A2.FData)<FloatEq) or
                                      (A1.FData<A2.FData));
          T_STRING, T_SYM: R.IData := Longint(A1.SData<=A2.SData);
          T_PROC: Begin R.IData := 0; KillIfNoSym(A1); KillIfNoSym(A2); End;
     End;
     Push(R);
End;

Procedure GEFun;
Var
   A1,A2,R: TEntry;
Begin
     Pop(A2);
     Pop(A1);
     R.Class := T_INT;
     If A1.Class<>A2.Class then
     Begin
          R.IData := 0;
          Push(R);
          Exit;
     End;
     Case A1.Class of
          T_INT: R.IData := Longint(A1.IData>=A2.IData);
          T_FLOAT: R.IData := Longint((Abs(A1.FData-A2.FData)<FloatEq) or
                                      (A1.FData>A2.FData));
          T_STRING, T_SYM: R.IData := Longint(A1.SData>=A2.SData);
          T_PROC: Begin R.IData := 0; KillIfNoSym(A1); KillIfNoSym(A2); End;
     End;
     Push(R);
End;

Procedure NEFun;
Var
   A1,A2,R: TEntry;
Begin
     Pop(A2);
     Pop(A1);
     R.Class := T_INT;
     If A1.Class<>A2.Class then
     Begin
          R.IData := 0;
          Push(R);
          Exit;
     End;
     Case A1.Class of
          T_INT: R.IData := Longint(A1.IData<>A2.IData);
          T_FLOAT: R.IData := Longint(Abs(A1.FData-A2.FData)>FloatEq);
          T_STRING, T_SYM: R.IData := Longint(A1.SData<>A2.SData);
          T_PROC: Begin R.IData := 0; KillIfNoSym(A1); KillIfNoSym(A2); End;
     End;
     Push(R);
End;

Procedure OrFun;
Var
   A1,A2,R: TEntry;
Begin
     Pop(A2);
     Pop(A1);
     R.Class := T_INT;
     If (A1.Class<>T_INT) or (A2.Class<>T_INT) then Error('OR: Expects two ints as args');
     R.IData := A1.IData+A2.IData;
     If R.IData<>0 then R.IData := 1;
     Push(R);
End;

Procedure AndFun;
Var
   A1,A2,R: TEntry;
Begin
     Pop(A2);
     Pop(A1);
     R.Class := T_INT;
     If (A1.Class<>T_INT) or (A2.Class<>T_INT) then Error('AND: Expects two ints as args');
     If (A1.IData<>0) and (A2.IData<>0) then R.IData := 1 else
                                             R.IData := 0;
     Push(R);
End;

Procedure XorFun;
Var
   A1,A2,R: TEntry;
Begin
     Pop(A2);
     Pop(A1);
     R.Class := T_INT;
     If (A1.Class<>T_INT) or (A2.Class<>T_INT) then Error('XOR: Expects two ints as args');
     If ((A1.IData=0)  and (A2.IData<>0)) or
        ((A1.IData<>0) and (A2.IData=0) ) then R.IData := 1 else
                                               R.IData := 0;
     Push(R);
End;

Procedure NotFun;
Var
   A,R: TEntry;
Begin
     Pop(A);
     R.Class := T_INT;
     If (A.Class<>T_INT) then Error('NOT: Expects an int as arg');
     If (A.IData<>0) then R.IData := 0 else
                          R.IData := 1;
     Push(R);
End;

Procedure TypeOfFun;
Var
   A,R: TEntry;
Begin
     Pop(A);
     R.Class := T_SYM;
     Case A.Class of
          T_NONE:   R.SData := 'NONE';
          T_INT:    R.SData := 'INT';
          T_FLOAT:  R.SData := 'FLOAT';
          T_STRING: R.SData := 'STRING';
          T_SYM:    R.SData := 'SYMBOL';
          T_PROC:   Begin R.SData := 'PROCEDURE'; KillIfNoSym(A); End;
     End;
     Push(R);
End;

Procedure DupFun;
Var
   T: TEntry;
Begin
     Pop(T);
     Push(T);
     Push(T);
End;

Procedure UntilFun;
Var
   Ini,Tst,Stp,Prc: TEntry;
Function InLoop: Boolean;
Var
   R: TEntry;
Begin
     RunProc(Tst);
     Pop(R);
     If R.Class<>T_INT then Error('UNTIL: Test procedure should return an INT');
     InLoop := Not(R.IData=1);
End;
Begin
     Pop(Prc);
     Pop(Stp);
     Pop(Tst);
     Pop(Ini);
     If (Ini.Class<>T_PROC) or (Tst.Class<>T_PROC) or
        (Stp.Class<>T_PROC) or (Prc.Class<>T_PROC) then
          Error('UNTIL: Arguments 1 to 4 should be procedures');
     RunProc(Ini);
     Repeat
           RunProc(Prc);
           RunProc(Stp);
     Until Not(InLoop);
     KillIfNoSym(Ini);
     KillIfNoSym(Tst);
     KillIfNoSym(Stp);
     KillIfNoSym(Prc);
End;

Procedure WhileFun;
Var
   Ini,Tst,Stp,Prc: TEntry;
Function InLoop: Boolean;
Var
   R: TEntry;
Begin
     RunProc(Tst);
     Pop(R);
     If R.Class<>T_INT then Error('WHILE: Test procedure should return an INT');
     InLoop := R.IData=1;
End;
Begin
     Pop(Prc);
     Pop(Stp);
     Pop(Tst);
     Pop(Ini);
     If (Ini.Class<>T_PROC) or (Tst.Class<>T_PROC) or
        (Stp.Class<>T_PROC) or (Prc.Class<>T_PROC) then
          Error('WHILE: Arguments 1 to 4 should be procedures');
     RunProc(Ini);
     While InLoop do
     Begin
          RunProc(Prc);
          RunProc(Stp);
     End;
     KillIfNoSym(Ini);
     KillIfNoSym(Tst);
     KillIfNoSym(Stp);
     KillIfNoSym(Prc);
End;

Procedure ModFun;
Var
   A1,A2,R: TEntry;
Begin
     Pop(A2);
     Pop(A1);
     If (A1.Class<>T_INT) or (A2.Class<>T_INT) then Error('MOD: Both args must be ints');
     R.Class := T_INT;
     R.IData := A1.IData mod A2.IData;
     Push(R);
End;

Procedure XPosFun;
Var
   R: TEntry;
Begin
     R.Class := T_INT;
     R.IData := WhereX;
     Push(R);
End;

Procedure YPosFun;
Var
   R: TEntry;
Begin
     R.Class := T_INT;
     R.IData := WhereY;
     Push(R);
End;

Procedure SetAttrFun;
Var
   A: TEntry;
Begin
     Pop(A);
     If A.Class<>T_INT then Error('SETATTR: Requires INT as argument');
     TextAttr := A.IData;
End;

Procedure GetAttrFun;
Var
   R: TEntry;
Begin
     R.Class := T_INT;
     R.IData := TextAttr;
     Push(R);
End;

Procedure LocateFun;
Var
   X,Y: TEntry;
Begin
     Pop(Y);
     Pop(X);
     If (X.Class<>T_INT) or (Y.Class<>T_INT) then Error('LOCATE: Requires INTS as arguments');
     GotoXY(X.IData,Y.IData);
End;

Procedure DelayFun;
Var
   T: TEntry;
Begin
     Pop(T);
     If T.Class<>T_INT then Error('DELAY: Value must be an INT specifying mS');
     Delay(T.IData);
End;

Procedure SoundFun;
Var
   A: TEntry;
Begin
     Pop(A);
     If A.Class<>T_INT then Error('SOUND: Value must be frequency as INT');
     Sound(A.IData);
End;

Procedure WindowFun;
Var
   X1,Y1,X2,Y2: TEntry;
Function NotInt(T: TEntry): Boolean; Begin NotInt := T.Class<>T_INT; End;
Begin
     Pop(Y2); Pop(X2);
     Pop(Y1); Pop(X1);
     If NotInt(X1) or NotInt(Y1) or
        NotInt(X2) or NotInt(Y2) then Error('WINDOW: Needs 4 integer arguments');
     Window(X1.IData,Y1.IData,X2.IData,Y2.IData);
End;

Procedure SinFun;
Var
   A,R: TEntry;
Begin
     Pop(A);
     If Not(A.Class in [T_INT,T_FLOAT]) then Error('SIN: Needs a numeric argument');
     R.Class := T_FLOAT;
     If A.Class=T_INT then R.FData := Sin(A.IData) else
                           R.FData := Sin(A.FData);
     Push(R);
End;

Procedure CosFun;
Var
   A,R: TEntry;
Begin
     Pop(A);
     If Not(A.Class in [T_INT,T_FLOAT]) then Error('COS: Needs a numeric argument');
     R.Class := T_FLOAT;
     If A.Class=T_INT then R.FData := Cos(A.IData) else
                           R.FData := Cos(A.FData);
     Push(R);
End;

Procedure ArcTanFun;
Var
   A,R: TEntry;
Begin
     Pop(A);
     If Not(A.Class in [T_INT,T_FLOAT]) then Error('ARCTAN: Needs a numeric argument');
     R.Class := T_FLOAT;
     If A.Class=T_INT then R.FData := ArcTan(A.IData) else
                           R.FData := ArcTan(A.FData);
     Push(R);
End;

Procedure LnFun;
Var
   A,R: TEntry;
Begin
     Pop(A);
     If Not(A.Class in [T_INT,T_FLOAT]) then Error('LN: Needs a numeric argument');
     R.Class := T_FLOAT;
     If A.Class=T_INT then R.FData := Ln(A.IData) else
                           R.FData := Ln(A.FData);
     Push(R);
End;

Procedure ExpFun;
Var
   A,R: TEntry;
Begin
     Pop(A);
     If Not(A.Class in [T_INT,T_FLOAT]) then Error('EXP: Needs a numeric argument');
     R.Class := T_FLOAT;
     If A.Class=T_INT then R.FData := Exp(A.IData) else
                           R.FData := Exp(A.FData);
     Push(R);
End;

Procedure SqrFun;
Var
   A,R: TEntry;
Begin
     Pop(A);
     If Not(A.Class in [T_INT,T_FLOAT]) then Error('SQR: Needs a numeric argument');
     R.Class := T_FLOAT;
     If A.Class=T_INT then R.FData := Sqrt(A.IData) else
                           R.FData := Sqrt(A.FData);
     Push(R);
End;

Procedure RandomFun;
Var
   R: TEntry;
Begin
     R.Class := T_FLOAT;
     R.FData := Random;
     Push(R);
End;