{$M 65000,0,655360}

Program StackLang; {Slang :-)}

Uses Crt, Dos;

Const
     FloatEq    = 0;

     T_NONE     = 00000;
     T_INT      = 00001;
     T_FLOAT    = 00002;
     T_STRING   = 00003;
     T_PROC     = 00004;
     T_SYM      = 00005;

Type
    PProcLine = ^TProcLine;
    TProcLine = Record
                  Next: PProcLine;
                  Data: String;
                End;

    PEntry = ^TEntry;
    TEntry = Record
               Next: PEntry;
               Case Class: Byte of
                 T_INT: (IData: Longint);
                 T_FLOAT: (FData: Real);
                 T_STRING, T_SYM: (SData: String);
                 T_PROC: (PData: PProcLine);
             End;
    PSymbol = ^TSymbol;
    TSymbol = Record
                Next: PSymbol;
                Symbol: String;
                Entry: TEntry;
              End;

Var
   Stack: PEntry;
   SymTab: PSymbol;

Procedure KillProc(P: PProcLine); Forward;
Procedure RunProc(Var T: TEntry); Forward;

Procedure AddSymbol(S: String; Var V: TEntry);
Var
   P: PSymbol;
Begin
     New(P);
     P^.Next := SymTab;
     P^.Symbol := S;
     P^.Entry := V;
     SymTab := P;
End;

Procedure GetSymbol(S: String; Var V: TEntry);
Var
   P: PSymbol;
Begin
     V.Class := T_NONE;

     P := SymTab;
     While P<>Nil do
     Begin
          If P^.Symbol=S then
          Begin
               V := P^.Entry;
               Exit;
          End;
          P := P^.Next;
     End;
End;

Procedure Instructions;
Begin
     Writeln;
     Writeln('SLANG v1.00             Copyright (C) 1993 Tony Garnock-Jones');
     Writeln('===========================================================================');
     Writeln;
     Writeln('Syntax:');
     Writeln('  SLANG <progname> <progname> ...');
     Writeln;
     Writeln('<progname> is the name of a SLANG program to run. The programs');
     Writeln('           are run in sequential order, and the stack is not');
     Writeln('           cleared between programs.. the output from one is the');
     Writeln('           input to another.');
     Writeln;
     Writeln('See SLANG.DOC for a description of the language.');
     Halt(1);
End;

Procedure InitStack;
Begin
     Stack := Nil;
     SymTab := Nil;
End;

Function Size: Longint;
Var
   I: Longint;
   P: PEntry;
Begin
     P := Stack;
     I := 0;
     While P<>Nil do
     Begin
          Inc(I);
          P := P^.Next;
     End;
     Size := I;
End;

Procedure Push(Var T: TEntry);
Var
   P: PEntry;
Begin
     New(P);
     P^ := T;
     P^.Next := Stack;
     Stack := P;
End;

Procedure Pop(Var T: TEntry);
Var
   P: PEntry;
Begin
     If Size=0 then
     Begin
          T.Class := T_NONE;
          Exit;
     End;
     P := Stack;
     If P<>Nil then
     Begin
          Stack := Stack^.Next;
          P^.Next := Nil;
          T := P^;
          Dispose(P);
     End;
End;

Procedure PrintData(Var T: TEntry);
Begin
     Case T.Class of
          T_NONE: Writeln('NONE! Should this be here?');
          T_INT: Writeln(T.IData);
          T_FLOAT: Writeln(T.FData);
          T_STRING: Writeln(T.SData);
          T_PROC: Writeln('PROCEDURE');
     End;
End;

Procedure DumpStack;
Var
   T: TEntry;
Begin
     Writeln('Top:');
     Writeln;
     While Size>0 do
     Begin
          Pop(T);
          PrintData(T);
     End;
     Writeln;
End;

{========================================================0 PARSETOSTACK}

Function UpStr(S: String): String;
Var
   I: Integer;
Begin
     For I := 1 to Length(S) do S[I] := UpCase(S[I]);
     UpStr := S;
End;

Procedure ParseToStack(Var F: Text);
Var
   S: String;
   T: TEntry;
   P: PProcLine;
   Buff: String;
Procedure Trim(Var S: String);
Begin
     While (S<>'') and (S[1] in [' ',#9]) do S := Copy(S,2,255);
     While (S<>'') and (S[Length(S)] in [' ',#9]) do Dec(Byte(S[0]));
     If Pos(';',S)<>0 then S := Copy(S,1,Pos(';',S)-1);
End;
Function GetWord: String;
Var
   P: Byte;
   SS: String;
Begin
     Trim(Buff);
     While Buff='' do
     Begin
          If EOF(F) then
          Begin
               GetWord := '';
               Exit;
          End;
          Readln(F,Buff);
          Trim(Buff);
     End;
     P := Pos(' ',Buff);
     If P=0 then P := Length(Buff)+1;
     If Buff[1]='"' then
     Begin
          P := Pos('"',Copy(Buff,2,255))+2;
          If P<=1 then
          Begin
               Buff := Buff+'"';
               P := Length(Buff)+1;
          End;
     End;
     SS := Copy(Buff,1,P-1);
     If SS[1]<>'"' then SS := UpStr(SS);
     Buff := Copy(Buff,P+1,255);
     GetWord := SS;
End;
Procedure AddLine(S: String);
Var
   PP,PPP: PProcLine;
Begin
     PP := P;
     While PP^.Next<>Nil do PP := PP^.Next;
     New(PPP);
     PPP^.Next := Nil;
     PPP^.Data := S;
     PP^.Next := PPP;
End;
Begin
     Buff := '';
     New(P);
     P^.Next := Nil;
     P^.Data := '';

     T.Class := T_PROC;
     T.PData := P;

     While Not(EOF(F) and (Buff='')) do
     Begin
          S := GetWord;
          AddLine(S);
     End;

     Push(T);
End;

{========================================================0 END PARSETOSTACK}

Procedure Error(S: String);
Begin
     Writeln('ERROR::  ',S);
     Halt(2);
End;

{$I CMDS.PAS}

{========================================================0 RUNPROC}

Procedure KillProc(P: PProcLine);
Var
   PP: PProcLine;
Begin
     While P<>Nil do
     Begin
          PP := P^.Next;
          Dispose(P);
          P := PP;
     End;
End;

Procedure RunProc(Var T: TEntry);
Var
   Curr: PProcLine;
   SS: String;
   PSym, SymTabTop: PSymbol;
   TT: TEntry;
Function NotSym: Boolean;
Begin
     SS := Curr^.Data;
     If (SS<>'') and (SS[1]='''') then
     Begin
          TT.Class := T_SYM;
          TT.SData := Copy(SS,2,255);
          Push(TT);
          NotSym := False;
          Exit;
     End;
     If (SS<>'') and (SS[1]=',') then SS := Copy(SS,2,255);
     GetSymbol(SS,TT);
     If TT.Class<>T_NONE then
     Begin
          If (TT.Class=T_PROC) and (Curr^.Data[1]<>',') then RunProc(TT) else
                                                             Push(TT);
          NotSym := False;
          Exit;
     End;
     NotSym := True;
End;
Function NotCmd: Boolean;
Begin
     If Curr^.Data='+' then Begin AddFun; NotCmd := False; Exit; End;
     If Curr^.Data='-' then Begin SubFun; NotCmd := False; Exit; End;
     If Curr^.Data='*' then Begin MulFun; NotCmd := False; Exit; End;
     If Curr^.Data='/' then Begin DivFun; NotCmd := False; Exit; End;
     If Curr^.Data='<' then Begin LFun; NotCmd := False; Exit; End;
     If Curr^.Data='>' then Begin GFun; NotCmd := False; Exit; End;
     If Curr^.Data='==' then Begin EqFun; NotCmd := False; Exit; End;
     If Curr^.Data='<=' then Begin LEFun; NotCmd := False; Exit; End;
     If Curr^.Data='>=' then Begin GEFun; NotCmd := False; Exit; End;
     If Curr^.Data='<>' then Begin NEFun; NotCmd := False; Exit; End;
     If Curr^.Data='IF' then Begin IfFun; NotCmd := False; Exit; End;
     If Curr^.Data='LN' then Begin LnFun; NotCmd := False; Exit; End;
     If Curr^.Data='OR' then Begin OrFun; NotCmd := False; Exit; End;
     If Curr^.Data='AND' then Begin AndFun; NotCmd := False; Exit; End;
     If Curr^.Data='XOR' then Begin XorFun; NotCmd := False; Exit; End;
     If Curr^.Data='NOT' then Begin NotFun; NotCmd := False; Exit; End;
     If Curr^.Data='MOD' then Begin ModFun; NotCmd := False; Exit; End;
     If Curr^.Data='SQR' then Begin SqrFun; NotCmd := False; Exit; End;
     If Curr^.Data='EXP' then Begin ExpFun; NotCmd := False; Exit; End;
     If Curr^.Data='SET' then Begin SetFun; NotCmd := False; Exit; End;
     If Curr^.Data='SIN' then Begin SinFun; NotCmd := False; Exit; End;
     If Curr^.Data='COS' then Begin CosFun; NotCmd := False; Exit; End;
     If Curr^.Data='CLS' then Begin ClrScr; NotCmd := False; Exit; End;
     If Curr^.Data='DUP' then Begin DupFun; NotCmd := False; Exit; End;
     If Curr^.Data='DISP' then Begin DispFun; NotCmd := False; Exit; End;
     If Curr^.Data='DROP' then Begin DropFun; NotCmd := False; Exit; End;
     If Curr^.Data='HALT' then Begin HaltFun; NotCmd := False; Exit; End;
     If Curr^.Data='READ' then Begin ReadFun; NotCmd := False; Exit; End;
     If Curr^.Data='EVAL' then Begin EvalFun; NotCmd := False; Exit; End;
     If Curr^.Data='XPOS' then Begin XPosFun; NotCmd := False; Exit; End;
     If Curr^.Data='YPOS' then Begin YPosFun; NotCmd := False; Exit; End;
     If Curr^.Data='SWAP' then Begin SwapFun; NotCmd := False; Exit; End;
     If Curr^.Data='STR+' then Begin StrCatFun; NotCmd := False; Exit; End;
     If Curr^.Data='UPSTR' then Begin UpStrFun; NotCmd := False; Exit; End;
     If Curr^.Data='UNTIL' then Begin UntilFun; NotCmd := False; Exit; End;
     If Curr^.Data='WHILE' then Begin WhileFun; NotCmd := False; Exit; End;
     If Curr^.Data='->NUM' then Begin ToNumFun; NotCmd := False; Exit; End;
     If Curr^.Data='->STR' then Begin ToStrFun; NotCmd := False; Exit; End;
     If Curr^.Data='->CHR' then Begin ToChrFun; NotCmd := False; Exit; End;
     If Curr^.Data='ROUND' then Begin RoundFun; NotCmd := False; Exit; End;
     If Curr^.Data='DELAY' then Begin DelayFun; NotCmd := False; Exit; End;
     If Curr^.Data='SOUND' then Begin SoundFun; NotCmd := False; Exit; End;
     If Curr^.Data='DEFINE' then Begin DefineFun; NotCmd := False; Exit; End;
     If Curr^.Data='ARCTAN' then Begin ArcTanFun; NotCmd := False; Exit; End;
     If Curr^.Data='GETKEY' then Begin GetKeyFun; NotCmd := False; Exit; End;
     If Curr^.Data='WINDOW' then Begin WindowFun; NotCmd := False; Exit; End;
     If Curr^.Data='SUBSTR' then Begin SubStrFun; NotCmd := False; Exit; End;
     If Curr^.Data='STRLEN' then Begin StrLenFun; NotCmd := False; Exit; End;
     If Curr^.Data='TYPEOF' then Begin TypeOfFun; NotCmd := False; Exit; End;
     If Curr^.Data='IFELSE' then Begin IfElseFun; NotCmd := False; Exit; End;
     If Curr^.Data='LOCATE' then Begin LocateFun; NotCmd := False; Exit; End;
     If Curr^.Data='RANDOM' then Begin RandomFun; NotCmd := False; Exit; End;
     If Curr^.Data='NOSOUND' then Begin NoSound; NotCmd := False; Exit; End;
     If Curr^.Data='GETATTR' then Begin GetAttrFun; NotCmd := False; Exit; End;
     If Curr^.Data='SETATTR' then Begin SetAttrFun; NotCmd := False; Exit; End;
     If Curr^.Data='CHR->INT' then Begin ChrToIntFun; NotCmd := False; Exit; End;
     If Curr^.Data='RANDOMIZE' then Begin Randomize; NotCmd := False; Exit; End;
     If Curr^.Data='KEYPRESSED' then Begin KeyPressedFun; NotCmd := False; Exit; End;
     NotCmd := True;
End;
Function NotString: Boolean;
Var
   W: Word;
Begin
     If (Curr^.Data<>'') and (Curr^.Data[1]='"') then
     Begin
          TT.Class := T_STRING;
          TT.SData := Copy(Curr^.Data,2,Length(Curr^.Data)-2);
          While Pos('\',TT.SData)>0 do
          Begin
               W := Pos('\',TT.SData);
               Delete(TT.SData,W,1);
               Case TT.SData[W] of
                    'n','N': Begin
                               TT.SData[W] := #13;
                               Insert(#10,TT.SData,W+1);
                             End;
                    'r','R': TT.SData[W] := #13;
                    't','T': TT.SData[W] := #9;
                    '\': TT.SData[W] := #255;
               Else
                   Delete(TT.SData,W,1);
               End;
          End;
          While Pos(#255,TT.SData)>0 do TT.SData[Pos(#255,TT.SData)] := '\';
          Push(TT);
          NotString := False;
          Exit;
     End;
     NotString := True;
End;
Function NotFloat: Boolean;
Var
   C: Word;
Begin
     If Pos('.',Curr^.Data)>0 then
     Begin
          TT.Class := T_FLOAT;
          Val(Curr^.Data,TT.FData,C);
          Push(TT);
          NotFloat := False;
          Exit;
     End;
     NotFloat := True;
End;
Function NotInt: Boolean;
Var
   C: Word;
Function Numeric(S: String): Boolean;
Begin
     Numeric := (S<>'') and (S[1] in ['0'..'9','&']);
End;
Begin
     If Numeric(Curr^.Data) then
     Begin
          If Curr^.Data[1]='&' then Curr^.Data[1]:='$';
          TT.Class := T_INT;
          Val(Curr^.Data,TT.IData,C);
          Push(TT);
          NotInt := False;
          Exit;
     End;
     NotInt := True;
End;
Function NotProc: Boolean;
Var
   P: PProcLine;
   BCount: Longint;
Procedure AddLine(S: String);
Var
   PP,PPP: PProcLine;
Begin
     PP := P;
     While PP^.Next<>Nil do PP := PP^.Next;
     New(PPP);
     PPP^.Next := Nil;
     PPP^.Data := S;
     PP^.Next := PPP;
End;
Begin
     If Curr^.Data='{' then
     Begin
          New(P);
          P^.Next := Nil;
          P^.Data := '';

          TT.Class := T_PROC;
          TT.PData := P;
          BCount := 1;
          Curr := Curr^.Next;
          While BCount>0 do
          Begin
               If Curr^.Data='}' then Dec(BCount);
               If BCount>0 then
               Begin
                    If Curr^.Data='{' then Inc(BCount);
                    AddLine(Curr^.Data);
                    Curr := Curr^.Next;
               End;
          End;
          Push(TT);

          NotProc := False;
          Exit;
     End;
     NotProc := True;
End;
Begin
     If T.Class<>T_PROC then Exit;
     SymTabTop := SymTab;

     Curr := T.PData;
     While Curr<>Nil do
     Begin
          If NotSym then
          If NotCmd then
          If NotString then
          If NotFloat then
          If NotInt then
          If NotProc then
          If Curr^.Data<>'' then Error('UNDEFINED SYMBOL '+Curr^.Data);

          If Curr<>Nil then Curr := Curr^.Next;
     End;
     While SymTab<>SymTabTop do
     Begin
          PSym := SymTab;
          If SymTab^.Entry.Class=T_PROC then KillProc(SymTab^.Entry.PData);
          SymTab := SymTab^.Next;
          Dispose(PSym);
     End;
End;

{========================================================0 END RUNPROC}

Procedure CheckSwitch(S: String);
Begin
     Case UpCase(S[1]) of
          'I': Begin
                 Writeln('Interactive mode is forthcoming.'#13);
                 Halt(0);
               End;
     End;
End;

Procedure RunProg(S: String);
Var
   F: Text;
   T: TEntry;
   D: DirStr;
   N: NameStr;
   E: ExtStr;
Begin
     If (S<>'') and (S[1]='/') then
     Begin
          CheckSwitch(Copy(S,2,255));
          Exit;
     End;

     S := FExpand(S);
     FSplit(S,D,N,E);
     If E='' then S := S+'.SLA';

     Assign(F,S);
     Reset(F);

     ParseToStack(F);
     Close(F);

     Pop(T);
     AddSymbol('MAIN',T);
     RunProc(T);
End;

Var
   I: Integer;

Begin
     If ParamCount=0 then Instructions;

     InitStack;
     For I := 1 to ParamCount do RunProg(ParamStr(I));
End.
