(require 'gtk)

(define (hook x v)
  (let ((old-v (x)))
    (x (lambda _
	 (apply v _)
	 (apply old-v _)))))

;(hook gboxed-finalizer-hook (lambda _ (print "GBoxed finalizer: " _)))
;(hook gobject-ref-hook (lambda (o) (print "GObject   ref: " o)))
;(hook gobject-finalizer-hook (lambda (o) (print "GObject unref: " o)))

(define w (gtk-window-new 'toplevel))
(gtk-window-set-title w "Drawing Area")

(gsignal-connect w "destroy" (lambda _ (gtk-main-quit)))

(gtk-container-set-border-width w 8)

(define v (gtk-vbox-new #f 8))
(gtk-container-set-border-width v 8)
(gtk-container-add w v)

(define (add-da v label)
  (let ((l (gtk-label-new #f))
	(f (gtk-frame-new #f))
	(da (gtk-drawing-area-new)))
    (gtk-label-set-markup l label)
    (gtk-box-pack-start v l #f #f 0)

    (gtk-frame-set-shadow-type f 'in)
    (gtk-box-pack-start v f #t #t 0)

    (gtk-widget-set-size-request da 100 100)
    (gtk-container-add f da)

    da))

(let ((da (add-da v "<u>Checkerboard pattern</u>")))
;  (pretty-print (map car (gsignal-list-complete (gobject-type da))))
  (gsignal-connect
   da "realize"
   (lambda (widget)
     (let ((gc1 (gdk-gc-new (gtk-widget-window widget)))
	   (gc2 (gdk-gc-new (gtk-widget-window widget)))
	   (xsize 10)
	   (color1 (list->gdk-color '(30000 0 30000)))
	   (color2 (list->gdk-color '(65535 65535 65535))))
       (gdk-gc-set-rgb-fg-color gc1 color1)
       (gdk-gc-set-rgb-fg-color gc2 color2)
       (gsignal-connect
	da "expose_event"
	(lambda (da event)
	  (let* ((daw (gtk-widget-window da))
		 (allocation (gdk-rectangle->list (gtk-widget-allocation da)))
		 (width (third allocation))
		 (height (fourth allocation)))
	    (do ((n #f (not n))
		 (i 0 (+ i xsize)))
		((>= i width))
	      (do ((n n (not n))
		   (j 0 (+ j xsize)))
		  ((>= j height))
		(gdk-draw-rectangle daw (if n gc1 gc2) 1 i j xsize xsize))))
	  #t))))))

(define (draw-brush pm w x y)
  (let ((r (list->gdk-rectangle (list (- x 3)
				      (- y 3)
				      6 6))))
    (apply gdk-draw-rectangle pm
	   (gtk-style-black-gc
	    (gtk-widget-get-style w))
	   1
	   (gdk-rectangle->list r))
    (gdk-window-invalidate-rect (gtk-widget-window w)
				r
				#f)))

(let ((da (add-da v "<u>Scribble area</u>"))
      (pm #f))

  (gsignal-connect da "expose_event"
		   (lambda (widget event)
		     (if (not pm)
			 (error "No pixmap - not yet configured, it would seem"))
		     (receive (x y w h)
			 (apply values (gdk-rectangle->list (gdk-event-area event)))
		       (gdk-draw-drawable
			(gtk-widget-window widget)
			(gtk-style-fg-gc (gtk-widget-get-style widget)
					 (gtk-widget-get-state widget))
			pm
			x y
			x y
			w h))
		     #f))	; why false?

  (gsignal-connect da "configure_event"
		   (lambda (w event)
		     (let* ((allocation (gdk-rectangle->list
					 (gtk-widget-allocation w)))
			    (width (third allocation))
			    (height (fourth allocation)))
		       (set! pm (gdk-pixmap-new (gtk-widget-window w)
						width
						height
						-1))
		       (gdk-draw-rectangle pm
					   (gtk-style-white-gc
					    (gtk-widget-get-style w))
					   1
					   0 0
					   width height)
		       #t)))
					   
  (gsignal-connect da "motion_notify_event"
		   (lambda (w event)
		     (if (not pm)
			 (error "No pixmap - not yet configured, it would seem"))
		     ;; This call is very important; it requests the next motion event.
		     ;; If you don't call gdk_window_get_pointer() you'll only get
		     ;; a single motion event. The reason is that we specified
		     ;; GDK_POINTER_MOTION_HINT_MASK to gtk_widget_set_events().
		     ;; If we hadn't specified that, we could just use event->x, event->y
		     ;; as the pointer location. But we'd also get deluged in events.
		     ;; By requesting the next event as we handle the current one,
		     ;; we avoid getting a huge number of events faster than we
		     ;; can cope.
		     (receive (x y state)
			 (gdk-window-get-pointer (gdk-event-window event))
		       (if (memq 'button1-mask state)
			   (draw-brush pm w x y)))
		     #t))

  (gsignal-connect da "button_press_event"
		   (lambda (w event)
		     (if (not pm)
			 (error "No pixmap - not yet configured, it would seem"))
		     (if (= (gdk-event-button event) 1)
			 (receive (x y)
			     (gdk-event-xy event)
			   (draw-brush pm w x y)))
		     #t))

  (gtk-widget-set-events da (bitwise-ior (gtk-widget-get-events da)
					 (GdkEventMask->number '(leave-notify-mask
								 button-press-mask
								 pointer-motion-mask
								 pointer-motion-hint-mask)))))

(gtk-widget-show-all w)

(gtk:gc-when-idle #t)
(gtk-main)

(exit 0)
