#!/opt/chicken/bin/csi -quiet

(require 'gtk)

(define (make-menu . items)
  (let ((m (gtk-menu-new)))
    (for-each (lambda (i) (gtk-menu-shell-append m i))
	      items)
    m))

(define (make-menu-item . spec0)
    (let loop ((spec spec0)
	       (item #f))
      (cond
       ((null? spec) item)
       ((null? (cdr spec)) (error "make-menu-item: requires keyword-arguments only"
				  spec0))
       (else
	(let ((key (car spec))
	      (val (cadr spec))
	      (rest (cddr spec)))
	  (case key
	    ((#:label) (loop rest (gtk-menu-item-new-with-label val)))
	    ((#:widget)
	     (let ((i (or item (gtk-menu-item-new))))
	       (gtk-container-add i val)
	       (loop rest i)))
	    ((#:submenu)
	     (gtk-menu-item-set-submenu item val)
	     (loop rest item))
	    ((#:handler)
	     (gtk-signal-connect item 'activate val)
	     (loop rest item))
	    (else (error "make-menu-item: unknown keyword"
			 key))))))))

(define (make-button mne h)
  (let ((b (gtk-button-new-with-mnemonic mne)))
    (gtk-signal-connect b 'clicked h)
    b))

(define (test1)
  (let ((o (gtk-option-menu-new))
	(m (make-menu
	    (make-menu-item #:label "First"
			    #:handler (lambda (i) (print "Chose 1")))
	    (make-menu-item #:widget (gtk-button-new-with-label "Hello")
			    #:submenu (make-menu
				       (make-menu-item #:label "hi1"
						       #:handler (lambda (i) (print "Chose 2")))
				       (make-menu-item #:label "hi2")))
	    (make-menu-item #:label "Third"
			    #:handler (lambda (i) (print "Chose 3"))))))
    (gtk-option-menu-set-menu o m)
    o))

(let ((w (gtk-window-new 'toplevel))
      (v (gtk-vbox-new #t 4))
      (b (gtk-button-new-with-mnemonic "Hello, _world!"))
      (b2 (gtk-button-new-with-label "Die"))
      (b3 (gtk-button-new-from-stock "gtk-ok"))
      (tt (gtk-tooltips-new)))
;  (pretty-print (gobject-class-properties (gobject-type w)))
;  (newline)

  (gobject-set-property! w 'title "foobar")
;  (gobject-set-property! w 'width-request 200)
  (gobject-set-property! w 'height-request 200)

  (gtk-signal-connect w 'delete_event
		      (lambda (o evt)
			(print o ": got delete_event on w: " evt " "
			       (gdk-event-type evt))
			#t))
  (gtk-signal-connect w 'destroy (lambda (o)
				   (print o": got destroy on w")
				   (gtk-main-quit)))
  (gtk-signal-connect b 'clicked (lambda (o)
				   (print o ": B clicked")))
  (gtk-signal-connect b 'key_press_event (lambda (o evt)
					   (let ((s (gdk-event-string evt)))
					     (if (and (positive? (string-length s))
						      (equal? (string-ref s 0) #\tab))
						 (begin
						   (print "Tabbing over")
						   (gtk-window-set-focus w b2))
						 (begin
						   (print "Got " (gdk-event-type evt))
						   (print (gdk-event-string evt)))))
					   #t))
  (gtk-signal-connect b2 'clicked (lambda (o)
				    (gtk-widget-destroy w)))
  (gtk-tooltips-set-tip tt b2 "Yo, Yo, this will cause the program to quit, fool" "private what?")
  (gtk-signal-connect b3 'clicked (lambda (o)
				    (print "Yes!")))

;  (print (map car (gobject-class-properties (gobject-type v))))
  (gobject-set-property! v 'homogeneous #f)

  (gtk-container-add v b)
  (gtk-container-add v (test1))
  (gtk-container-add v b2)
  (gtk-container-add v b3)

  (gtk-container-add v (let ((c (gtk-calendar-new)))
			 (gtk-signal-connect c 'day-selected
					     (lambda (cal . _)
					       (print "SELECTED " cal
						      " " (gtk-calendar-get-date cal))))
			 (gtk-signal-connect c 'day-selected-double-click
					     (lambda (cal . _)
					       (print "DCLICK " cal
						      " " (gtk-calendar-get-date cal))))
			 c))

  (gtk-container-add v (let ((c (gtk-check-button-new-with-mnemonic "Chec_k it")))
;			 (print (map car (gsignal-list-complete (gobject-type c))))
			 (gtk-signal-connect c 'toggled
					     (lambda (cc)
;					       (pretty-print (map car (gobject-class-properties
;								       (gobject-type cc))))
					       (print "Check it: "
						      cc
						      (gobject-get-property cc 'active))))
			 c))

  (let* ((a (gtk-adjustment-new 3 0 6 0.1 0.2 0)))
    (gtk-signal-connect a 'value-changed
			(compose print gtk-adjustment-get-value))
    (gtk-container-add v (gtk-hscrollbar-new a))
    (gtk-container-add v (gtk-hscale-new a))
    (gtk-container-add v (gtk-spin-button-new a 0.1 1))
    )

  (gtk-container-add v (gtk-arrow-new 'up 'none))

  (gtk-container-add v (make-button "Colo_r"
				    (lambda _
				      (gtk-widget-show (gtk-color-selection-dialog-new
							"Choose a silly colour")))))

  (gtk-container-add v (make-button "My__Fi_le"
				    (lambda _
				      (let ((f (gtk-file-selection-new
						"Choose a file")))
					(print (gsignal-list (gobject-type f)))
					(gtk-widget-show f)))))

  (gtk-signal-connect b 'enter (lambda (_)
				 (print "ENTER")
				 (gtk-button-set-label _ "ENTERED")))
  (gtk-signal-connect b 'leave (lambda (_)
				 (print "LEAVE")
				 (gtk-button-set-label _ "LEFT")))
  (gtk-button-set-relief b 'none)

  (gobject-set-property! v 'border-width 4)

  (let ((sw (gtk-scrolled-window-new (null-gobject)
				     (null-gobject))))
    (gtk-scrolled-window-set-policy sw 'never 'automatic)
    (gtk-scrolled-window-add-with-viewport sw v)
    (gtk-container-add w sw))

  (gtk-widget-show-all w)
  (gtk-main))

(exit 0)
