(declare
 (usual-integrations)
 (export make-thunk-coroutine
	 make-unary-coroutine
	 make-coroutine)
)

(define (dead-coroutine . ignore)
  (error "Coroutine called after final result"))

; Zero-argument case:
;
(define (make-thunk-coroutine proc)
  (letrec ((callers-cc #f)
	   (state (lambda ()
		    (let ((final-result (proc (lambda (result)
						(call-with-current-continuation
						 (lambda (reenter)
						   (set! state (lambda () (reenter #t)))
						   (callers-cc result)))))))
		      (set! state dead-coroutine)
		      (callers-cc final-result)))))
    (lambda ()
      (call-with-current-continuation
       (lambda (return)
	 (set! callers-cc return)
	 (state))))))

; Single-argument case:
;
(define (make-unary-coroutine proc)
  (letrec ((callers-cc #f)
	   (state (lambda (arg)
		    (let ((final-result (proc (lambda (result)
						(call-with-current-continuation
						 (lambda (reenter)
						   (set! state reenter)
						   (callers-cc result))))
					      arg)))
		      (set! state dead-coroutine)
		      (callers-cc final-result)))))
    (lambda (arg)
      (call-with-current-continuation
       (lambda (return)
	 (set! callers-cc return)
	 (state arg))))))

; General case, n arguments:
;
(define (make-coroutine proc)
  (letrec ((callers-cc #f)
	   (state (lambda (args)
		    (let ((final-result (apply proc
					       (lambda (result)
						 (call-with-current-continuation
						  (lambda (reenter)
						    (set! state (lambda (args)
								  (if (null? args)
								      (reenter #t)
								      (apply reenter args))))
						    (callers-cc result))))
					       args)))
		      (set! state dead-coroutine)
		      (callers-cc final-result)))))
    (lambda args
      (call-with-current-continuation
       (lambda (return)
	 (set! callers-cc return)
	 (state args))))))
