(require 'db)

(define (assert-equal? a b . description)
  (if (equal? a b)
      (unless (null? description)
	      (print "assert-equal? succeeded " description ": " a))
      (error "assert-equal? failed"
	     (if (null? description) "#<no-description>" description)
	     a
	     b)))

(define (*db-test*)
  (assert-equal? "'hello'" (DB:quote-string "hello") "simple quoting")
  (assert-equal? "'a''b'" (DB:quote-string "a'b") "embedded quotes")
  (assert-equal? "'a\\\\b'" (DB:quote-string "a\\b") "embedded backslash")

  (assert-equal? "abc" (DB:trim-whitespace "abc  ") "trim on right")
  (assert-equal? "  abc" (DB:trim-whitespace "  abc  ") "trim on right only")
  (assert-equal? "  abc" (DB:trim-whitespace "  abc") "trim no-op")
  )

(*db-test*)
(exit 0)
