;; If you want to generate your parse-table at compile time, try
;; something like:
;;
;; (define-macro (build-table grammar terminals)
;;   (require 'lalr)
;;   (let ((table (lalr-table grammar terminals #f)))
;;     (list 'quasiquote table)))
;;
;; (define table (build-table
;; 	          ((expr --> expr expr-op term ,binary-apply) 
;; 		   (expr --> term ,identity)                  
;; 		   (term --> term term-op term0 ,binary-apply)
;; 		   (term --> term0 ,identity)
;; 		   (term0 --> lparen expr rparen ,(lambda (lp expr rp) expr))
;; 		   (term0 --> number ,identity)
;; 		   (number --> number digit ,(lambda (n d) (+ (* 10 n) d)))
;; 		   (number --> digit ,identity))
;; 	          (expr-op term-op lparen rparen digit)))
;;
;; This will cause the (build-table) expression to expand at compile
;; time to a quasiquoted parse-table vector containing unquotes as
;; specified in the literal grammar passed in to the macro.

(declare
 (export lalr-table
	 lalr-parser)
)

(define (1+ x) (+ x 1))
(include "associators.ss")
(include "lalr.ss")
