(require 'md5)

(define (assert-equal? a b . description)
  (if (equal? a b)
      (unless (null? description)
	      (print "assert-equal? succeeded " description ": " a))
      (error "assert-equal? failed"
	     (if (null? description) "#<no-description>" description)
	     a
	     b)))

(define (*test-md5*)
  (let ()
    (assert-equal? "68656c6c6f2c20776f726c6421" (md5-hex-encode "hello, world!")
		   "hex-encode-hello-world")
    (assert-equal? "0007" (md5-hex-encode (string (integer->char 0)
						  (integer->char 7)))
		   "hex-encode-embedded-nul")
    (assert-equal? "000000" (md5-hex-encode (make-string 3 (integer->char 0)))
		   "hex-encode-nul-string")
    (assert-equal? "202020" (md5-hex-encode "   ")
		   "hex-encode-spaces")

    (define hellomd5 "910c8bc73110b0cd1bc5d2bcae782511") ; "hello, world!\n"

    (let ((c (md5-init)))
      (md5-update c "hello, world!\n")
      (assert-equal? hellomd5 (md5-hex-encode (md5-final c)) "context-updating"))

    (assert-equal? hellomd5 (md5-hex-encode (md5 "hello, world!\n")) "hex-encode-md5sum")
  )
)

(*test-md5*)
(exit 0)
