#!/usr/local/bin/csi -quiet
(require 'multiplex)

;(define plex (make-multiplexor))

(define (assert-eq? a b . description)
  (if (eq? a b)
      (unless (null? description)
	      (print "assert-eq? succeeded " description ": " a))
      (error "assert-eq? failed"
	     (if (null? description) "#<no-description>" description)
	     a
	     b)))

(define (test-mailbox)
  (let ((b1 (make-empty-mailbox "b1"))
	(b2 (make-empty-mailbox "b2")))
    (mailbox-put! b1 'a)
    (assert-eq? 'a (mailbox-get! b1) "put then get")

    (let ((x #f))
      (call-with-current-continuation
       (lambda (escape)
	 (mailbox-get! b1 (lambda (box) (set! x #t) (escape #t)))))
      (assert-eq? x #t "empty handler"))

    (mailbox-put! b1 'a)
    (mailbox-put! b1 'b)
    (assert-eq? 'a (mailbox-get! b1) "ordering of puts")
    (assert-eq? 'b (mailbox-get! b1) "ordering of puts")

    (thread-start! (make-thread (lambda ()
				  (mailbox-put! b2 (mailbox-get! b1))
				  (mailbox-put! b2 (mailbox-get! b1)))
				"echo-twice"))
    (mailbox-put! b1 'x)
    (assert-eq? 'x (mailbox-get! b2) "thread communication")
    (mailbox-put! b1 'y)
    (assert-eq? 'y (mailbox-get! b2) "thread communication")
))

(let ((root (make-thread (lambda () (test-mailbox)) "test-root-thread")))
  (thread-start! root)
  (thread-join! root)
  (exit 0))
