(require 'multiplex)

;(set-gc-report! #t)

(define (*test-many-threads*)
  (let* ((n 10000)
	 (r 10000)
	 (x (make-vector n))
	 (answer (make-empty-mailbox)))
    (print "Starting all threads...")
    (do ((i 0 (+ i 1)))
	((= i n))
      (when (zero? (remainder i 100))
	    (print i))
      (vector-set! x i
		   (let ((m (make-empty-mailbox)))
		     (thread-start!
		      (make-thread
		       (lambda ()
			 (mailbox-put! answer #t)
			 (let loop ()
			   (let ((msg (mailbox-get! m)))
			     (when (car msg)
				   (print "Thread " i " got message " msg))
			     (loop))))))
		     m))
      (mailbox-get! answer))
    (print "Picking threads at random...")
    (do ((i 0 (+ i 1)))
	(#f)
      (let ((t (random n)))
	(let ((report (zero? (remainder i r))))
;	  (when report
;		(print (##sys#all-threads)))
	  (mailbox-put! (vector-ref x t) (list report 'message t i)))))))

(set-signal-handler! signal/int exit)
(*test-many-threads*)
(exit 0)