<!DOCTYPE style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN" [
<!ENTITY % a4paper "ignore">
<!ENTITY % docscm-html "ignore">

<![%docscm-html;[
<!ENTITY % docscm-print "ignore">
<!ENTITY docbook.dsl PUBLIC "-//Norman Walsh//DOCUMENT DocBook HTML Stylesheet//EN" CDATA dsssl>
]]>

<!ENTITY % docscm-print "include">

<![%docscm-print;[
<!ENTITY docbook.dsl PUBLIC "-//Norman Walsh//DOCUMENT DocBook Print Stylesheet//EN" CDATA dsssl>
]]>

]>

<style-sheet>
<style-specification use="docbook">
<style-specification-body> 

;---------------------------------------------------------------------------
; Common customisation

(define %section-autolabel% #t)
(define bop-footnotes #t)

<![%a4paper;[
(define %paper-type% "A4")
]]>

(element classname
  (process-children))

(element (classsynopsis fieldsynopsis)
  (make sequence
    (literal " ")
    (process-children)))

(element varname
  ($italic-seq$))

(element methodparam
  (let ((choice (attribute-string (normalize "choice")))
        (rep (attribute-string (normalize "rep"))))
    ($italic-seq$
     (make sequence
       (literal " ")
       (if (equal? choice (normalize "opt"))
	   (literal "[")
	   (empty-sosofo))
       (process-children)
       (if (equal? choice (normalize "opt"))
	   (literal "]")
	   (empty-sosofo))
       (if (equal? rep (normalize "repeat"))
	   (make sequence
	     (literal " ")
	     (literal "..."))
	   (empty-sosofo))))))

(element void
  (empty-sosofo))

(element methodname
  (process-children))

(element parameter
  ($mono-seq$))

(element symbol
  ($mono-seq$))

;---------------------------------------------------------------------------
; Print customisation

<![%docscm-print;[

(define (indent-docscm-synopsis)
  (- (inherited-start-indent) 1em))

(element classsynopsis
  (make paragraph
    keep-with-next?: #t
    start-indent: (indent-docscm-synopsis)
    (make sequence
      font-weight: 'bold
      (literal "record: "))
    (make sequence
      use: verbatim-style
      (literal "(make-")
      (process-node-list (select-elements (descendants (current-node))
					  (normalize "classname")))
      (process-node-list (select-elements (children (current-node))
					  (normalize "fieldsynopsis")))
      (literal ")"))))

(element fieldsynopsis
  (make paragraph
    keep-with-next?: #t
    start-indent: (indent-docscm-synopsis)
    (make sequence
      font-weight: 'bold
      (literal "variable: "))
    (make sequence
      use: verbatim-style
      (process-node-list (select-elements (children (current-node))
					  (normalize "varname"))))))

(element methodsynopsis
  (let* ((nd		(current-node))
	 (methodname	(select-elements (children nd) (normalize "methodname")))
         (param		(select-elements (children nd) (normalize "methodparam")))
	 (role		(attribute-string (normalize "role") nd)))
    (make paragraph
      keep-with-next?: #t
      start-indent: (indent-docscm-synopsis)
      (make sequence
	font-weight: 'bold
	(if (equal? role "macro")
	    (literal "macro: ")
	    (literal "procedure: ")))
      (make sequence
	use: verbatim-style
	(literal "(")
	(process-node-list methodname)
	(process-node-list param)
	(literal ")")))))

]]>

;---------------------------------------------------------------------------
; HTML customisation

<![%docscm-html;[

(element classsynopsis
  (make element gi: "P"
	(make element gi: "B"
	      (literal "record: "))
	(make element gi: "TT"
	      (literal "(make-")
	      (process-node-list (select-elements (descendants (current-node))
						  (normalize "classname")))
	      (process-node-list (select-elements (children (current-node))
						  (normalize "fieldsynopsis")))
	      (literal ")"))))

(element fieldsynopsis
  (make element gi: "P"
	(make element gi: "B"
	      (literal "variable: "))
	(make element gi: "TT"
	      (process-node-list (select-elements (children (current-node))
						  (normalize "varname"))))))

(element methodsynopsis
  (let* ((nd		(current-node))
	 (methodname	(select-elements (children nd) (normalize "methodname")))
         (param		(select-elements (children nd) (normalize "methodparam")))
	 (role		(attribute-string (normalize "role") nd)))
    (make element gi: "P"
	  (make element gi: "B"
		(if (equal? role "macro")
		    (literal "macro: ")
		    (literal "procedure: ")))
	  (make element gi: "TT"
		(literal "(")
		(process-node-list methodname)
		(process-node-list param)
		(literal ")")))))

]]>

</style-specification-body>
</style-specification>
<external-specification id="docbook" document="docbook.dsl">
</style-sheet>
